unit DeskName;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, DebugW, Win2Tree;

type
  TfDesktopName = class(TForm)
    HideTimer: TTimer;
    RepaintTimer: TTimer;
    procedure HideTimerTimer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure Paint; override;
  public
    Buf_Text         : TBitmap;
    Buf_Mask         : TBitmap;
    ForegroundWindow : THandle;
    TextX, TextY     : Integer;
    { Public declarations }
  end;

var
  fDesktopName: TfDesktopName;

implementation

uses Main;

{$R *.DFM}

procedure TfDesktopName.HideTimerTimer(Sender: TObject);
begin
  HideTimer.Enabled := False;
  RepaintTimer.Enabled := False;
  Hide;
  if IsWindow(ForegroundWindow) then begin
    SetForegroundWindow(fMain.Handle);
    SetForegroundWindow(ForegroundWindow);
    {$IFDEF SDEBUG}try Assert(False) except on E:EAssertionFailed do DebugWAddEString(E.Message, 'DeskName, restoring focus for %d = "%s"', [ForegroundWindow, GetWindowTitle(ForegroundWindow)]); end;{$ENDIF}
  end;
end;

procedure TfDesktopName.FormCreate(Sender: TObject);
begin
  Buf_Mask                    := TBitmap.Create;
  Buf_Mask.Canvas.Brush.Style := bsSolid;
  Buf_Mask.Canvas.Brush.Color := clBlack;

  Buf_Text                    := TBitmap.Create;
  Buf_Text.Canvas.Brush.Style := bsSolid;
  Buf_Text.Canvas.Brush.Color := clBlack;

  fDesktopName.Brush.Style    := bsClear;
  fDesktopName.BorderStyle    := bsNone
end;

procedure TfDesktopName.FormShow(Sender: TObject);
begin
  Sleep(25);
  
  Width             := Canvas.TextWidth(Caption)+20;
  Height            := Canvas.TextHeight(Caption)+Round(20*600/800);
  TextX             := (Width-Canvas.TextWidth(Caption)) div 2;
  TextY             := (Height-Canvas.TextHeight(Caption)) div 2;

  fDesktopName.Left := (Screen.Width - Width) div 2;
  fDesktopName.Top  := (Screen.Height - Height) div 2;

  Buf_Mask.Width  := ClientWidth;
  Buf_Mask.Height := ClientHeight;
  Buf_Text.Width  := ClientWidth;
  Buf_Text.Height := ClientHeight;

  SetForegroundWindow(Handle);
  
  HideTimer.Enabled := True;
end;

procedure TfDesktopName.Paint;
begin
  Canvas.Font.Assign(Font);
  Canvas.Font.Color  := clBlack;
  Canvas.Brush.Style := bsClear;
  Canvas.TextOut(TextX-2, TextY  , Caption);
  Canvas.TextOut(TextX+2, TextY  , Caption);
  Canvas.TextOut(TextX  , TextY-2, Caption);
  Canvas.TextOut(TextX  , TextY+2, Caption);

  Canvas.Font.Color:= clWhite;
  Canvas.TextOut(TextX, TextY, Caption);

  Canvas.Brush.Style := bsClear;
end;

end.
