{ 
    SemTel version 1.0.0 ... comfortable telnet client
    Copyright (C) 1995-2000 Jan Tomasek <jan@tomasek.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
{-------------------------------------------------------------------------------
Version  : 0.81.00
Date     : 01.05.1998
Dialog   : EditHotKey, dialog without a title whitch grab pressed syskey
History  : 01.05.1998 QC
TODO     :
-------------------------------------------------------------------------------}
unit PromtKey;

interface

uses
  WinTypes, WinProcs,  Forms,    Keygrab, Menus,
  Classes,  Controls,  StdCtrls, ExtCtrls;

type
  TfEditHotKey = class(TForm)
    Panel       : TPanel;
    FPromptText : TLabel;
    KeyGrabber  : TKeyGrabber;
    PressedKey  : TLabel;
    procedure KeyChage(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    FShortCut  : TShortCut;
    Procedure WPromtText(S:String);
  public
    { Public declarations }
    property PromptText  : String write WPromtText;
    property ShortCut    : TShortCut read FShortCut;
  end;

Var
  fEditHotKey : TfEditHotKey;
implementation
Uses
  STConfig, kUnits;

{$R *.DFM}
Const
  VK_0 = $30;
  VK_9 = $39;
  VK_A = $41;
  VK_Z = $5A;

Procedure TfEditHotKey.WPromtText(S:String);
Begin
  FPromptText.Caption:=S;
End;

procedure TfEditHotKey.KeyChage(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  FShortCut := Menus.ShortCut(Key, Shift);
  PressedKey.Caption := ShortCutToText(FShortCut);
  If Key=VK_ESCAPE Then
   Begin
     FShortCut   := 0;
     ModalResult := mrCancel;
   End;
  If (Key in [VK_F1..VK_F24,VK_DELETE])or
     (((Shift=[ssCtrl])or(Shift=[ssAlt])or(Shift=[ssCtrl,ssAlt])or(Shift=[ssCtrl,ssShift])or(Shift=[ssCtrl,ssAlt,ssShift])))and
     (Key in[VK_INSERT,VK_DELETE,VK_0..VK_9,VK_A..VK_Z,VK_F1..VK_F24]) Then
   Begin
     MessageBeep(1);
     ModalResult:=mrOk;
   End;
end;

procedure TfEditHotKey.FormShow(Sender: TObject);
begin
  FShortCut          := 0;
  PressedKey.Caption := ShortCutToText(FShortCut)
end;

procedure TfEditHotKey.FormCreate(Sender: TObject);
begin
  SetWindowLong(Handle,GWL_STYLE, GetWindowLong(Handle,GWL_STYLE) AND NOT WS_CAPTION);
  Height:=ClientHeight;
end;


initialization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuPromptKey, 'initialization', '');{$ENDIF}
{$IFDEF Win32}finalization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuPromptKey, 'finalization', '');{$ENDIF}{$ENDIF}
end.
